import QtQuick 1.1 
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {


MbSubMenu {
    id: batteryCellVoltages14Item
    description: qsTr("Battery Cell Voltages")

    subpage: Component {
        PageBatteryDetailsCellVoltages14 {
            title: batteryCellVoltages14Item.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}


MbSubMenu {
    id: batteryCellTemperatures14Item
    description: qsTr("Battery Cell Temperatures")
    subpage: Component {
        PageBatteryDetailsCellTemperatures14 {
            title: batteryCellTemperatures14Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsTemperature14Item
    description: qsTr("BMS Temperature")
    subpage: Component {
        PageBatteryDetailsBMSTemperature14 {
            title: bmsTemperature14Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsCurrent14Item
    description: qsTr("Module Current")
    subpage: Component {
        PageBatteryDetailsBMSCurrent14 {
            title: bmsCurrent14Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}


        }
}
