import QtQuick 1.1 
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {


MbSubMenu {
    id: batteryCellVoltages15Item
    description: qsTr("Battery Cell Voltages")

    subpage: Component {
        PageBatteryDetailsCellVoltages15 {
            title: batteryCellVoltages15Item.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}


MbSubMenu {
    id: batteryCellTemperatures15Item
    description: qsTr("Battery Cell Temperatures")
    subpage: Component {
        PageBatteryDetailsCellTemperatures15 {
            title: batteryCellTemperatures15Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsTemperature15Item
    description: qsTr("BMS Temperature")
    subpage: Component {
        PageBatteryDetailsBMSTemperature15 {
            title: bmsTemperature15Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsCurrent15Item
    description: qsTr("Module Current")
    subpage: Component {
        PageBatteryDetailsBMSCurrent15 {
            title: bmsCurrent15Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}


        }
}
