#!/bin/sh

# Get the directory where this script lives (the mod folder)
MOD_DIR="$(cd "$(dirname "$0")" && pwd)"

echo "[INFO] Starting mod installation..."

# 1. Install batterycells init.d script
echo "[INFO] Installing init.d script..."
cp "$MOD_DIR/init.d/batterycells" /etc/init.d/
chmod +x /etc/init.d/batterycells
update-rc.d batterycells defaults

# 2. Install scripts in /data
echo "[INFO] Installing data scripts..."
cp "$MOD_DIR/data/batterycell_daemon.py" /data/
cp "$MOD_DIR/data/parse_can.sh" /data/

# Create velib_python directory and copy full repo contents properly
mkdir -p /data/velib_python
cp -r "$MOD_DIR/data/velib_python-master/." /data/velib_python/

# Set permissions
chmod +x /data/parse_can.sh
chmod +x /data/batterycell_daemon.py




# 3. Backup original QML files if not already backed up
BACKUP_DIR="/data/Venus_GUI_Mod/backup"
QML_DIR="/opt/victronenergy/gui/qml"

mkdir -p "$BACKUP_DIR"

for file in BatteryDetails.qml PageBatteryDetails.qml; do
    if [ ! -f "$BACKUP_DIR/${file}.copy" ]; then
        echo "[INFO] Backing up original $file"
        cp "$QML_DIR/$file" "$BACKUP_DIR/${file}.copy"
    else
        echo "[INFO] Backup for $file already exists, skipping"
    fi
done

# 4. Copy altered files (overwrite originals)
echo "[INFO] Installing altered QML files..."
cp "$MOD_DIR/qml/BatteryDetails.qml" "$QML_DIR/"
cp "$MOD_DIR/qml/PageBatteryDetails.qml" "$QML_DIR/"

# 5. Copy all added QML files
echo "[INFO] Installing added QML files..."

# BatteryModules 1 to 15
cp "$MOD_DIR/qml/PageBatteryDetailsBatteryModules.qml" "$QML_DIR/"
for i in $(seq 1 15); do
    cp "$MOD_DIR/qml/PageBatteryDetailsBatteryModule${i}.qml" "$QML_DIR/"
done

# BMSCurrent 1 (no number) + 2 to 15
cp "$MOD_DIR/qml/PageBatteryDetailsBMSCurrent.qml" "$QML_DIR/"
for i in $(seq 2 15); do
    cp "$MOD_DIR/qml/PageBatteryDetailsBMSCurrent${i}.qml" "$QML_DIR/"
done

# BMSTemperatures 1 + 2 to 15
cp "$MOD_DIR/qml/PageBatteryDetailsBMSTemperature.qml" "$QML_DIR/"
for i in $(seq 2 15); do
    cp "$MOD_DIR/qml/PageBatteryDetailsBMSTemperature${i}.qml" "$QML_DIR/"
done

# CellVoltages 1 + 2 to 15
cp "$MOD_DIR/qml/PageBatteryDetailsCellVoltages.qml" "$QML_DIR/"
for i in $(seq 2 15); do
    cp "$MOD_DIR/qml/PageBatteryDetailsCellVoltages${i}.qml" "$QML_DIR/"
done

# CellTemperatures 1 + 2 to 15
cp "$MOD_DIR/qml/PageBatteryDetailsCellTemperatures.qml" "$QML_DIR/"
for i in $(seq 2 15); do
    cp "$MOD_DIR/qml/PageBatteryDetailsCellTemperatures${i}.qml" "$QML_DIR/"
done

echo "[INFO] Installation completed successfully."
