import QtQuick 1.1
import com.victron.velib 1.0
import "utils.js" as Utils

Item {
id: itemContainer
property string bindPrefix
property bool anyItemValid: false

property VBusItemCheckValid modulesOnline: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesOnline")
    text: valid ? value + " " + qsTr("online") : invalidText
}
property VBusItemCheckValid modulesOffline: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesOffline")
    text: valid ? value + " " + qsTr("offline") : invalidText
}
property VBusItemCheckValid nrOfModulesBlockingCharge: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesBlockingCharge")
}
property VBusItemCheckValid nrOfModulesBlockingDischarge: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesBlockingDischarge")
}
property VBusItemCheckValid nrOfModulesOnline: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesOnline")
}
property VBusItemCheckValid nrOfModulesOffline: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/NrOfModulesOffline")
}
property VBusItemCheckValid minCellVoltage: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MinCellVoltage")
}
property VBusItemCheckValid maxCellVoltage: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MaxCellVoltage")
}
property VBusItemCheckValid minCellTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MinCellTemperature")
    displayUnit: user.temperatureUnit
}
property VBusItemCheckValid maxCellTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MaxCellTemperature")
    displayUnit: user.temperatureUnit
}
property VBusItemCheckValid minVoltageCellId: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MinVoltageCellId")
}
property VBusItemCheckValid maxVoltageCellId: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MaxVoltageCellId")
}
property VBusItemCheckValid minTemperatureCellId: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MinTemperatureCellId")
}
property VBusItemCheckValid maxTemperatureCellId: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/System/MaxTemperatureCellId")
}
property VBusItemCheckValid installedCapacity: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/InstalledCapacity")
}
property VBusItemCheckValid connectionInformation: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/ConnectionInformation")
}


property VBusItemCheckValid module1cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell00/Voltage") }
property VBusItemCheckValid module1cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell01/Voltage") }
property VBusItemCheckValid module1cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell02/Voltage") }
property VBusItemCheckValid module1cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell03/Voltage") }
property VBusItemCheckValid module1cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell04/Voltage") }
property VBusItemCheckValid module1cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell05/Voltage") }
property VBusItemCheckValid module1cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell06/Voltage") }
property VBusItemCheckValid module1cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell07/Voltage") }
property VBusItemCheckValid module1cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell08/Voltage") }
property VBusItemCheckValid module1cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell09/Voltage") }
property VBusItemCheckValid module1cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell10/Voltage") }
property VBusItemCheckValid module1cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell11/Voltage") }
property VBusItemCheckValid module1cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell12/Voltage") }
property VBusItemCheckValid module1cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell13/Voltage") }
property VBusItemCheckValid module1cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell14/Voltage") }
property VBusItemCheckValid module1cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell15/Voltage") }


property VBusItemCheckValid module1cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell00/Temperature") }
property VBusItemCheckValid module1cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell01/Temperature") }
property VBusItemCheckValid module1cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell02/Temperature") }
property VBusItemCheckValid module1cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell03/Temperature") }
property VBusItemCheckValid module1cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell04/Temperature") }
property VBusItemCheckValid module1cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell05/Temperature") }
property VBusItemCheckValid module1cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell06/Temperature") }
property VBusItemCheckValid module1cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell07/Temperature") }
property VBusItemCheckValid module1cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell08/Temperature") }
property VBusItemCheckValid module1cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell09/Temperature") }
property VBusItemCheckValid module1cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell10/Temperature") }
property VBusItemCheckValid module1cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell11/Temperature") }
property VBusItemCheckValid module1cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell12/Temperature") }
property VBusItemCheckValid module1cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell13/Temperature") }
property VBusItemCheckValid module1cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell14/Temperature") }
property VBusItemCheckValid module1cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module1/Cell15/Temperature") }


property VBusItemCheckValid module1bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module1/Bms/Current")
}
property VBusItemCheckValid module1bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module1/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module2cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell00/Voltage") }
property VBusItemCheckValid module2cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell01/Voltage") }
property VBusItemCheckValid module2cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell02/Voltage") }
property VBusItemCheckValid module2cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell03/Voltage") }
property VBusItemCheckValid module2cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell04/Voltage") }
property VBusItemCheckValid module2cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell05/Voltage") }
property VBusItemCheckValid module2cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell06/Voltage") }
property VBusItemCheckValid module2cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell07/Voltage") }
property VBusItemCheckValid module2cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell08/Voltage") }
property VBusItemCheckValid module2cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell09/Voltage") }
property VBusItemCheckValid module2cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell10/Voltage") }
property VBusItemCheckValid module2cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell11/Voltage") }
property VBusItemCheckValid module2cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell12/Voltage") }
property VBusItemCheckValid module2cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell13/Voltage") }
property VBusItemCheckValid module2cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell14/Voltage") }
property VBusItemCheckValid module2cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell15/Voltage") }


property VBusItemCheckValid module2cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell00/Temperature") }
property VBusItemCheckValid module2cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell01/Temperature") }
property VBusItemCheckValid module2cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell02/Temperature") }
property VBusItemCheckValid module2cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell03/Temperature") }
property VBusItemCheckValid module2cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell04/Temperature") }
property VBusItemCheckValid module2cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell05/Temperature") }
property VBusItemCheckValid module2cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell06/Temperature") }
property VBusItemCheckValid module2cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell07/Temperature") }
property VBusItemCheckValid module2cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell08/Temperature") }
property VBusItemCheckValid module2cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell09/Temperature") }
property VBusItemCheckValid module2cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell10/Temperature") }
property VBusItemCheckValid module2cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell11/Temperature") }
property VBusItemCheckValid module2cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell12/Temperature") }
property VBusItemCheckValid module2cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell13/Temperature") }
property VBusItemCheckValid module2cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell14/Temperature") }
property VBusItemCheckValid module2cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module2/Cell15/Temperature") }


property VBusItemCheckValid module2bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module2/Bms/Current")
}
property VBusItemCheckValid module2bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module2/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module3cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell00/Voltage") }
property VBusItemCheckValid module3cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell01/Voltage") }
property VBusItemCheckValid module3cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell02/Voltage") }
property VBusItemCheckValid module3cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell03/Voltage") }
property VBusItemCheckValid module3cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell04/Voltage") }
property VBusItemCheckValid module3cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell05/Voltage") }
property VBusItemCheckValid module3cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell06/Voltage") }
property VBusItemCheckValid module3cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell07/Voltage") }
property VBusItemCheckValid module3cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell08/Voltage") }
property VBusItemCheckValid module3cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell09/Voltage") }
property VBusItemCheckValid module3cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell10/Voltage") }
property VBusItemCheckValid module3cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell11/Voltage") }
property VBusItemCheckValid module3cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell12/Voltage") }
property VBusItemCheckValid module3cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell13/Voltage") }
property VBusItemCheckValid module3cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell14/Voltage") }
property VBusItemCheckValid module3cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell15/Voltage") }

property VBusItemCheckValid module3cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell00/Temperature") }
property VBusItemCheckValid module3cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell01/Temperature") }
property VBusItemCheckValid module3cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell02/Temperature") }
property VBusItemCheckValid module3cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell03/Temperature") }
property VBusItemCheckValid module3cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell04/Temperature") }
property VBusItemCheckValid module3cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell05/Temperature") }
property VBusItemCheckValid module3cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell06/Temperature") }
property VBusItemCheckValid module3cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell07/Temperature") }
property VBusItemCheckValid module3cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell08/Temperature") }
property VBusItemCheckValid module3cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell09/Temperature") }
property VBusItemCheckValid module3cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell10/Temperature") }
property VBusItemCheckValid module3cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell11/Temperature") }
property VBusItemCheckValid module3cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell12/Temperature") }
property VBusItemCheckValid module3cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell13/Temperature") }
property VBusItemCheckValid module3cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell14/Temperature") }
property VBusItemCheckValid module3cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module3/Cell15/Temperature") }

property VBusItemCheckValid module3bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module3/Bms/Current")
}
property VBusItemCheckValid module3bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module3/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module4cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell00/Voltage") }
property VBusItemCheckValid module4cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell01/Voltage") }
property VBusItemCheckValid module4cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell02/Voltage") }
property VBusItemCheckValid module4cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell03/Voltage") }
property VBusItemCheckValid module4cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell04/Voltage") }
property VBusItemCheckValid module4cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell05/Voltage") }
property VBusItemCheckValid module4cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell06/Voltage") }
property VBusItemCheckValid module4cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell07/Voltage") }
property VBusItemCheckValid module4cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell08/Voltage") }
property VBusItemCheckValid module4cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell09/Voltage") }
property VBusItemCheckValid module4cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell10/Voltage") }
property VBusItemCheckValid module4cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell11/Voltage") }
property VBusItemCheckValid module4cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell12/Voltage") }
property VBusItemCheckValid module4cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell13/Voltage") }
property VBusItemCheckValid module4cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell14/Voltage") }
property VBusItemCheckValid module4cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell15/Voltage") }

property VBusItemCheckValid module4cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell00/Temperature") }
property VBusItemCheckValid module4cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell01/Temperature") }
property VBusItemCheckValid module4cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell02/Temperature") }
property VBusItemCheckValid module4cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell03/Temperature") }
property VBusItemCheckValid module4cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell04/Temperature") }
property VBusItemCheckValid module4cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell05/Temperature") }
property VBusItemCheckValid module4cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell06/Temperature") }
property VBusItemCheckValid module4cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell07/Temperature") }
property VBusItemCheckValid module4cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell08/Temperature") }
property VBusItemCheckValid module4cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell09/Temperature") }
property VBusItemCheckValid module4cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell10/Temperature") }
property VBusItemCheckValid module4cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell11/Temperature") }
property VBusItemCheckValid module4cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell12/Temperature") }
property VBusItemCheckValid module4cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell13/Temperature") }
property VBusItemCheckValid module4cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell14/Temperature") }
property VBusItemCheckValid module4cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module4/Cell15/Temperature") }


property VBusItemCheckValid module4bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module4/Bms/Current")
}
property VBusItemCheckValid module4bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module4/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module5cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell00/Voltage") }
property VBusItemCheckValid module5cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell01/Voltage") }
property VBusItemCheckValid module5cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell02/Voltage") }
property VBusItemCheckValid module5cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell03/Voltage") }
property VBusItemCheckValid module5cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell04/Voltage") }
property VBusItemCheckValid module5cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell05/Voltage") }
property VBusItemCheckValid module5cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell06/Voltage") }
property VBusItemCheckValid module5cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell07/Voltage") }
property VBusItemCheckValid module5cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell08/Voltage") }
property VBusItemCheckValid module5cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell09/Voltage") }
property VBusItemCheckValid module5cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell10/Voltage") }
property VBusItemCheckValid module5cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell11/Voltage") }
property VBusItemCheckValid module5cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell12/Voltage") }
property VBusItemCheckValid module5cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell13/Voltage") }
property VBusItemCheckValid module5cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell14/Voltage") }
property VBusItemCheckValid module5cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell15/Voltage") }

property VBusItemCheckValid module5cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell00/Temperature") }
property VBusItemCheckValid module5cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell01/Temperature") }
property VBusItemCheckValid module5cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell02/Temperature") }
property VBusItemCheckValid module5cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell03/Temperature") }
property VBusItemCheckValid module5cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell04/Temperature") }
property VBusItemCheckValid module5cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell05/Temperature") }
property VBusItemCheckValid module5cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell06/Temperature") }
property VBusItemCheckValid module5cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell07/Temperature") }
property VBusItemCheckValid module5cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell08/Temperature") }
property VBusItemCheckValid module5cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell09/Temperature") }
property VBusItemCheckValid module5cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell10/Temperature") }
property VBusItemCheckValid module5cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell11/Temperature") }
property VBusItemCheckValid module5cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell12/Temperature") }
property VBusItemCheckValid module5cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell13/Temperature") }
property VBusItemCheckValid module5cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell14/Temperature") }
property VBusItemCheckValid module5cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module5/Cell15/Temperature") }


property VBusItemCheckValid module5bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module5/Bms/Current")
}
property VBusItemCheckValid module5bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module5/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module6cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell00/Voltage") }
property VBusItemCheckValid module6cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell01/Voltage") }
property VBusItemCheckValid module6cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell02/Voltage") }
property VBusItemCheckValid module6cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell03/Voltage") }
property VBusItemCheckValid module6cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell04/Voltage") }
property VBusItemCheckValid module6cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell05/Voltage") }
property VBusItemCheckValid module6cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell06/Voltage") }
property VBusItemCheckValid module6cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell07/Voltage") }
property VBusItemCheckValid module6cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell08/Voltage") }
property VBusItemCheckValid module6cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell09/Voltage") }
property VBusItemCheckValid module6cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell10/Voltage") }
property VBusItemCheckValid module6cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell11/Voltage") }
property VBusItemCheckValid module6cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell12/Voltage") }
property VBusItemCheckValid module6cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell13/Voltage") }
property VBusItemCheckValid module6cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell14/Voltage") }
property VBusItemCheckValid module6cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell15/Voltage") }

property VBusItemCheckValid module6cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell00/Temperature") }
property VBusItemCheckValid module6cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell01/Temperature") }
property VBusItemCheckValid module6cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell02/Temperature") }
property VBusItemCheckValid module6cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell03/Temperature") }
property VBusItemCheckValid module6cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell04/Temperature") }
property VBusItemCheckValid module6cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell05/Temperature") }
property VBusItemCheckValid module6cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell06/Temperature") }
property VBusItemCheckValid module6cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell07/Temperature") }
property VBusItemCheckValid module6cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell08/Temperature") }
property VBusItemCheckValid module6cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell09/Temperature") }
property VBusItemCheckValid module6cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell10/Temperature") }
property VBusItemCheckValid module6cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell11/Temperature") }
property VBusItemCheckValid module6cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell12/Temperature") }
property VBusItemCheckValid module6cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell13/Temperature") }
property VBusItemCheckValid module6cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell14/Temperature") }
property VBusItemCheckValid module6cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module6/Cell15/Temperature") }

property VBusItemCheckValid module6bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module6/Bms/Current")
}
property VBusItemCheckValid module6bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module6/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module7cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell00/Voltage") }
property VBusItemCheckValid module7cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell01/Voltage") }
property VBusItemCheckValid module7cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell02/Voltage") }
property VBusItemCheckValid module7cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell03/Voltage") }
property VBusItemCheckValid module7cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell04/Voltage") }
property VBusItemCheckValid module7cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell05/Voltage") }
property VBusItemCheckValid module7cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell06/Voltage") }
property VBusItemCheckValid module7cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell07/Voltage") }
property VBusItemCheckValid module7cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell08/Voltage") }
property VBusItemCheckValid module7cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell09/Voltage") }
property VBusItemCheckValid module7cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell10/Voltage") }
property VBusItemCheckValid module7cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell11/Voltage") }
property VBusItemCheckValid module7cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell12/Voltage") }
property VBusItemCheckValid module7cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell13/Voltage") }
property VBusItemCheckValid module7cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell14/Voltage") }
property VBusItemCheckValid module7cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell15/Voltage") }

property VBusItemCheckValid module7cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell00/Temperature") }
property VBusItemCheckValid module7cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell01/Temperature") }
property VBusItemCheckValid module7cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell02/Temperature") }
property VBusItemCheckValid module7cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell03/Temperature") }
property VBusItemCheckValid module7cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell04/Temperature") }
property VBusItemCheckValid module7cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell05/Temperature") }
property VBusItemCheckValid module7cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell06/Temperature") }
property VBusItemCheckValid module7cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell07/Temperature") }
property VBusItemCheckValid module7cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell08/Temperature") }
property VBusItemCheckValid module7cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell09/Temperature") }
property VBusItemCheckValid module7cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell10/Temperature") }
property VBusItemCheckValid module7cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell11/Temperature") }
property VBusItemCheckValid module7cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell12/Temperature") }
property VBusItemCheckValid module7cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell13/Temperature") }
property VBusItemCheckValid module7cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell14/Temperature") }
property VBusItemCheckValid module7cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module7/Cell15/Temperature") }

property VBusItemCheckValid module7bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module7/Bms/Current")
}
property VBusItemCheckValid module7bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module7/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module8cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell00/Voltage") }
property VBusItemCheckValid module8cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell01/Voltage") }
property VBusItemCheckValid module8cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell02/Voltage") }
property VBusItemCheckValid module8cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell03/Voltage") }
property VBusItemCheckValid module8cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell04/Voltage") }
property VBusItemCheckValid module8cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell05/Voltage") }
property VBusItemCheckValid module8cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell06/Voltage") }
property VBusItemCheckValid module8cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell07/Voltage") }
property VBusItemCheckValid module8cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell08/Voltage") }
property VBusItemCheckValid module8cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell09/Voltage") }
property VBusItemCheckValid module8cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell10/Voltage") }
property VBusItemCheckValid module8cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell11/Voltage") }
property VBusItemCheckValid module8cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell12/Voltage") }
property VBusItemCheckValid module8cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell13/Voltage") }
property VBusItemCheckValid module8cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell14/Voltage") }
property VBusItemCheckValid module8cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell15/Voltage") }

property VBusItemCheckValid module8cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell00/Temperature") }
property VBusItemCheckValid module8cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell01/Temperature") }
property VBusItemCheckValid module8cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell02/Temperature") }
property VBusItemCheckValid module8cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell03/Temperature") }
property VBusItemCheckValid module8cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell04/Temperature") }
property VBusItemCheckValid module8cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell05/Temperature") }
property VBusItemCheckValid module8cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell06/Temperature") }
property VBusItemCheckValid module8cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell07/Temperature") }
property VBusItemCheckValid module8cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell08/Temperature") }
property VBusItemCheckValid module8cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell09/Temperature") }
property VBusItemCheckValid module8cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell10/Temperature") }
property VBusItemCheckValid module8cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell11/Temperature") }
property VBusItemCheckValid module8cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell12/Temperature") }
property VBusItemCheckValid module8cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell13/Temperature") }
property VBusItemCheckValid module8cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell14/Temperature") }
property VBusItemCheckValid module8cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module8/Cell15/Temperature") }

property VBusItemCheckValid module8bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module8/Bms/Current")
}
property VBusItemCheckValid module8bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module8/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module9cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell00/Voltage") }
property VBusItemCheckValid module9cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell01/Voltage") }
property VBusItemCheckValid module9cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell02/Voltage") }
property VBusItemCheckValid module9cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell03/Voltage") }
property VBusItemCheckValid module9cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell04/Voltage") }
property VBusItemCheckValid module9cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell05/Voltage") }
property VBusItemCheckValid module9cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell06/Voltage") }
property VBusItemCheckValid module9cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell07/Voltage") }
property VBusItemCheckValid module9cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell08/Voltage") }
property VBusItemCheckValid module9cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell09/Voltage") }
property VBusItemCheckValid module9cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell10/Voltage") }
property VBusItemCheckValid module9cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell11/Voltage") }
property VBusItemCheckValid module9cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell12/Voltage") }
property VBusItemCheckValid module9cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell13/Voltage") }
property VBusItemCheckValid module9cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell14/Voltage") }
property VBusItemCheckValid module9cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell15/Voltage") }

property VBusItemCheckValid module9cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell00/Temperature") }
property VBusItemCheckValid module9cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell01/Temperature") }
property VBusItemCheckValid module9cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell02/Temperature") }
property VBusItemCheckValid module9cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell03/Temperature") }
property VBusItemCheckValid module9cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell04/Temperature") }
property VBusItemCheckValid module9cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell05/Temperature") }
property VBusItemCheckValid module9cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell06/Temperature") }
property VBusItemCheckValid module9cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell07/Temperature") }
property VBusItemCheckValid module9cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell08/Temperature") }
property VBusItemCheckValid module9cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell09/Temperature") }
property VBusItemCheckValid module9cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell10/Temperature") }
property VBusItemCheckValid module9cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell11/Temperature") }
property VBusItemCheckValid module9cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell12/Temperature") }
property VBusItemCheckValid module9cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell13/Temperature") }
property VBusItemCheckValid module9cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell14/Temperature") }
property VBusItemCheckValid module9cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module9/Cell15/Temperature") }

property VBusItemCheckValid module9bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module9/Bms/Current")
}
property VBusItemCheckValid module9bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module9/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module10cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell00/Voltage") }
property VBusItemCheckValid module10cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell01/Voltage") }
property VBusItemCheckValid module10cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell02/Voltage") }
property VBusItemCheckValid module10cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell03/Voltage") }
property VBusItemCheckValid module10cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell04/Voltage") }
property VBusItemCheckValid module10cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell05/Voltage") }
property VBusItemCheckValid module10cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell06/Voltage") }
property VBusItemCheckValid module10cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell07/Voltage") }
property VBusItemCheckValid module10cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell08/Voltage") }
property VBusItemCheckValid module10cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell09/Voltage") }
property VBusItemCheckValid module10cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell10/Voltage") }
property VBusItemCheckValid module10cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell11/Voltage") }
property VBusItemCheckValid module10cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell12/Voltage") }
property VBusItemCheckValid module10cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell13/Voltage") }
property VBusItemCheckValid module10cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell14/Voltage") }
property VBusItemCheckValid module10cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell15/Voltage") }

property VBusItemCheckValid module10cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell00/Temperature") }
property VBusItemCheckValid module10cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell01/Temperature") }
property VBusItemCheckValid module10cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell02/Temperature") }
property VBusItemCheckValid module10cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell03/Temperature") }
property VBusItemCheckValid module10cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell04/Temperature") }
property VBusItemCheckValid module10cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell05/Temperature") }
property VBusItemCheckValid module10cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell06/Temperature") }
property VBusItemCheckValid module10cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell07/Temperature") }
property VBusItemCheckValid module10cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell08/Temperature") }
property VBusItemCheckValid module10cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell09/Temperature") }
property VBusItemCheckValid module10cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell10/Temperature") }
property VBusItemCheckValid module10cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell11/Temperature") }
property VBusItemCheckValid module10cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell12/Temperature") }
property VBusItemCheckValid module10cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell13/Temperature") }
property VBusItemCheckValid module10cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell14/Temperature") }
property VBusItemCheckValid module10cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module10/Cell15/Temperature") }


property VBusItemCheckValid module10bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module10/Bms/Current")
}
property VBusItemCheckValid module10bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module10/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module11cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell00/Voltage") }
property VBusItemCheckValid module11cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell01/Voltage") }
property VBusItemCheckValid module11cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell02/Voltage") }
property VBusItemCheckValid module11cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell03/Voltage") }
property VBusItemCheckValid module11cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell04/Voltage") }
property VBusItemCheckValid module11cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell05/Voltage") }
property VBusItemCheckValid module11cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell06/Voltage") }
property VBusItemCheckValid module11cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell07/Voltage") }
property VBusItemCheckValid module11cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell08/Voltage") }
property VBusItemCheckValid module11cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell09/Voltage") }
property VBusItemCheckValid module11cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell10/Voltage") }
property VBusItemCheckValid module11cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell11/Voltage") }
property VBusItemCheckValid module11cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell12/Voltage") }
property VBusItemCheckValid module11cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell13/Voltage") }
property VBusItemCheckValid module11cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell14/Voltage") }
property VBusItemCheckValid module11cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell15/Voltage") }

property VBusItemCheckValid module11cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell00/Temperature") }
property VBusItemCheckValid module11cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell01/Temperature") }
property VBusItemCheckValid module11cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell02/Temperature") }
property VBusItemCheckValid module11cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell03/Temperature") }
property VBusItemCheckValid module11cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell04/Temperature") }
property VBusItemCheckValid module11cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell05/Temperature") }
property VBusItemCheckValid module11cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell06/Temperature") }
property VBusItemCheckValid module11cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell07/Temperature") }
property VBusItemCheckValid module11cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell08/Temperature") }
property VBusItemCheckValid module11cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell09/Temperature") }
property VBusItemCheckValid module11cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell10/Temperature") }
property VBusItemCheckValid module11cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell11/Temperature") }
property VBusItemCheckValid module11cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell12/Temperature") }
property VBusItemCheckValid module11cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell13/Temperature") }
property VBusItemCheckValid module11cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell14/Temperature") }
property VBusItemCheckValid module11cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module11/Cell15/Temperature") }

property VBusItemCheckValid module11bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module11/Bms/Current")
}
property VBusItemCheckValid module11bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module11/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module12cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell00/Voltage") }
property VBusItemCheckValid module12cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell01/Voltage") }
property VBusItemCheckValid module12cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell02/Voltage") }
property VBusItemCheckValid module12cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell03/Voltage") }
property VBusItemCheckValid module12cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell04/Voltage") }
property VBusItemCheckValid module12cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell05/Voltage") }
property VBusItemCheckValid module12cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell06/Voltage") }
property VBusItemCheckValid module12cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell07/Voltage") }
property VBusItemCheckValid module12cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell08/Voltage") }
property VBusItemCheckValid module12cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell09/Voltage") }
property VBusItemCheckValid module12cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell10/Voltage") }
property VBusItemCheckValid module12cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell11/Voltage") }
property VBusItemCheckValid module12cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell12/Voltage") }
property VBusItemCheckValid module12cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell13/Voltage") }
property VBusItemCheckValid module12cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell14/Voltage") }
property VBusItemCheckValid module12cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell15/Voltage") }

property VBusItemCheckValid module12cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell00/Temperature") }
property VBusItemCheckValid module12cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell01/Temperature") }
property VBusItemCheckValid module12cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell02/Temperature") }
property VBusItemCheckValid module12cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell03/Temperature") }
property VBusItemCheckValid module12cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell04/Temperature") }
property VBusItemCheckValid module12cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell05/Temperature") }
property VBusItemCheckValid module12cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell06/Temperature") }
property VBusItemCheckValid module12cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell07/Temperature") }
property VBusItemCheckValid module12cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell08/Temperature") }
property VBusItemCheckValid module12cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell09/Temperature") }
property VBusItemCheckValid module12cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell10/Temperature") }
property VBusItemCheckValid module12cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell11/Temperature") }
property VBusItemCheckValid module12cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell12/Temperature") }
property VBusItemCheckValid module12cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell13/Temperature") }
property VBusItemCheckValid module12cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell14/Temperature") }
property VBusItemCheckValid module12cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module12/Cell15/Temperature") }


property VBusItemCheckValid module12bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module12/Bms/Current")
}
property VBusItemCheckValid module12bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module12/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module13cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell00/Voltage") }
property VBusItemCheckValid module13cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell01/Voltage") }
property VBusItemCheckValid module13cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell02/Voltage") }
property VBusItemCheckValid module13cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell03/Voltage") }
property VBusItemCheckValid module13cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell04/Voltage") }
property VBusItemCheckValid module13cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell05/Voltage") }
property VBusItemCheckValid module13cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell06/Voltage") }
property VBusItemCheckValid module13cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell07/Voltage") }
property VBusItemCheckValid module13cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell08/Voltage") }
property VBusItemCheckValid module13cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell09/Voltage") }
property VBusItemCheckValid module13cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell10/Voltage") }
property VBusItemCheckValid module13cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell11/Voltage") }
property VBusItemCheckValid module13cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell12/Voltage") }
property VBusItemCheckValid module13cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell13/Voltage") }
property VBusItemCheckValid module13cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell14/Voltage") }
property VBusItemCheckValid module13cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell15/Voltage") }

property VBusItemCheckValid module13cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell00/Temperature") }
property VBusItemCheckValid module13cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell01/Temperature") }
property VBusItemCheckValid module13cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell02/Temperature") }
property VBusItemCheckValid module13cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell03/Temperature") }
property VBusItemCheckValid module13cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell04/Temperature") }
property VBusItemCheckValid module13cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell05/Temperature") }
property VBusItemCheckValid module13cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell06/Temperature") }
property VBusItemCheckValid module13cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell07/Temperature") }
property VBusItemCheckValid module13cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell08/Temperature") }
property VBusItemCheckValid module13cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell09/Temperature") }
property VBusItemCheckValid module13cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell10/Temperature") }
property VBusItemCheckValid module13cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell11/Temperature") }
property VBusItemCheckValid module13cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell12/Temperature") }
property VBusItemCheckValid module13cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell13/Temperature") }
property VBusItemCheckValid module13cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell14/Temperature") }
property VBusItemCheckValid module13cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module13/Cell15/Temperature") }

property VBusItemCheckValid module13bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module13/Bms/Current")
}
property VBusItemCheckValid module13bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module13/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module14cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell00/Voltage") }
property VBusItemCheckValid module14cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell01/Voltage") }
property VBusItemCheckValid module14cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell02/Voltage") }
property VBusItemCheckValid module14cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell03/Voltage") }
property VBusItemCheckValid module14cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell04/Voltage") }
property VBusItemCheckValid module14cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell05/Voltage") }
property VBusItemCheckValid module14cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell06/Voltage") }
property VBusItemCheckValid module14cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell07/Voltage") }
property VBusItemCheckValid module14cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell08/Voltage") }
property VBusItemCheckValid module14cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell09/Voltage") }
property VBusItemCheckValid module14cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell10/Voltage") }
property VBusItemCheckValid module14cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell11/Voltage") }
property VBusItemCheckValid module14cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell12/Voltage") }
property VBusItemCheckValid module14cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell13/Voltage") }
property VBusItemCheckValid module14cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell14/Voltage") }
property VBusItemCheckValid module14cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell15/Voltage") }

property VBusItemCheckValid module14cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell00/Temperature") }
property VBusItemCheckValid module14cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell01/Temperature") }
property VBusItemCheckValid module14cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell02/Temperature") }
property VBusItemCheckValid module14cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell03/Temperature") }
property VBusItemCheckValid module14cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell04/Temperature") }
property VBusItemCheckValid module14cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell05/Temperature") }
property VBusItemCheckValid module14cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell06/Temperature") }
property VBusItemCheckValid module14cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell07/Temperature") }
property VBusItemCheckValid module14cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell08/Temperature") }
property VBusItemCheckValid module14cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell09/Temperature") }
property VBusItemCheckValid module14cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell10/Temperature") }
property VBusItemCheckValid module14cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell11/Temperature") }
property VBusItemCheckValid module14cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell12/Temperature") }
property VBusItemCheckValid module14cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell13/Temperature") }
property VBusItemCheckValid module14cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell14/Temperature") }
property VBusItemCheckValid module14cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module14/Cell15/Temperature") }

property VBusItemCheckValid module14bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module14/Bms/Current")
}
property VBusItemCheckValid module14bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module14/Bms/Temperature")
    displayUnit: user.temperatureUnit
}


property VBusItemCheckValid module15cell00Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell00/Voltage") }
property VBusItemCheckValid module15cell01Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell01/Voltage") }
property VBusItemCheckValid module15cell02Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell02/Voltage") }
property VBusItemCheckValid module15cell03Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell03/Voltage") }
property VBusItemCheckValid module15cell04Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell04/Voltage") }
property VBusItemCheckValid module15cell05Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell05/Voltage") }
property VBusItemCheckValid module15cell06Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell06/Voltage") }
property VBusItemCheckValid module15cell07Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell07/Voltage") }
property VBusItemCheckValid module15cell08Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell08/Voltage") }
property VBusItemCheckValid module15cell09Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell09/Voltage") }
property VBusItemCheckValid module15cell10Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell10/Voltage") }
property VBusItemCheckValid module15cell11Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell11/Voltage") }
property VBusItemCheckValid module15cell12Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell12/Voltage") }
property VBusItemCheckValid module15cell13Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell13/Voltage") }
property VBusItemCheckValid module15cell14Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell14/Voltage") }
property VBusItemCheckValid module15cell15Voltage: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell15/Voltage") }

property VBusItemCheckValid module15cell00Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell00/Temperature") }
property VBusItemCheckValid module15cell01Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell01/Temperature") }
property VBusItemCheckValid module15cell02Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell02/Temperature") }
property VBusItemCheckValid module15cell03Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell03/Temperature") }
property VBusItemCheckValid module15cell04Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell04/Temperature") }
property VBusItemCheckValid module15cell05Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell05/Temperature") }
property VBusItemCheckValid module15cell06Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell06/Temperature") }
property VBusItemCheckValid module15cell07Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell07/Temperature") }
property VBusItemCheckValid module15cell08Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell08/Temperature") }
property VBusItemCheckValid module15cell09Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell09/Temperature") }
property VBusItemCheckValid module15cell10Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell10/Temperature") }
property VBusItemCheckValid module15cell11Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell11/Temperature") }
property VBusItemCheckValid module15cell12Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell12/Temperature") }
property VBusItemCheckValid module15cell13Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell13/Temperature") }
property VBusItemCheckValid module15cell14Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell14/Temperature") }
property VBusItemCheckValid module15cell15Temperature: VBusItemCheckValid { bind: Utils.path(bindPrefix, "/Module15/Cell15/Temperature") }

property VBusItemCheckValid module15bmsCurrent: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module15/Bms/Current")
}
property VBusItemCheckValid module15bmsTemperature: VBusItemCheckValid {
    bind: Utils.path(bindPrefix, "/Module15/Bms/Temperature")
    displayUnit: user.temperatureUnit
}



property VBusItemCheckValid module1: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module1")
}

property VBusItemCheckValid module2: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module2")
}

property VBusItemCheckValid module3: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module3")
}

property VBusItemCheckValid module4: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module4")
}

property VBusItemCheckValid module5: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module5")
}

property VBusItemCheckValid module6: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module6")
}

property VBusItemCheckValid module7: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module7")
}

property VBusItemCheckValid module8: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module8")
}

property VBusItemCheckValid module9: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module9")
}

property VBusItemCheckValid module10: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module10")
}

property VBusItemCheckValid module11: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module11")
}

property VBusItemCheckValid module12: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module12")
}

property VBusItemCheckValid module13: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module13")
}

property VBusItemCheckValid module14: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module14")
}

property VBusItemCheckValid module15: VBusItemCheckValid{
   bind: Utils.path(bindPrefix, "/Module15")
}
}