import QtQuick 1.1
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {
                MbItemRow {
                        description: qsTr("Lowest cell voltage")
                        values: [
                                MbTextBlock { item.text: details.minVoltageCellId.text; visible: details.minVoltageCellId.valid },
                                MbTextBlock { item.text: details.minCellVoltage.text }
                        ]
                        show: details.minCellVoltage.valid
                }

                MbItemRow {
                        description: qsTr("Highest cell voltage")
                        values: [
                                MbTextBlock { item.text: details.maxVoltageCellId.text; visible: details.maxVoltageCellId.valid },
                                MbTextBlock { item.text: details.maxCellVoltage.text }
                        ]
                        show: details.maxCellVoltage.valid
                }

                MbItemRow {
                        description: qsTr("Minimum cell temperature")
                        values: [
                                MbTextBlock { item.text: details.minTemperatureCellId.text; visible: details.minTemperatureCellId.valid },
                                MbTextBlock { item.text: details.minCellTemperature.text }
                        ]
                        show: details.minCellTemperature.valid
                }

                MbItemRow {
                        description: qsTr("Maximum cell temperature")
                        values: [
                                MbTextBlock { item.text: details.maxTemperatureCellId.text; visible: details.maxTemperatureCellId.valid },
                                MbTextBlock { item.text: details.maxCellTemperature.text }
                        ]
                        show: details.maxCellTemperature.valid
                }

                MbItemRow {
                        description: qsTr("Battery modules")
                        values: [
                                MbTextBlock { item.text: details.modulesOnline.text },
                                MbTextBlock { item.text: details.modulesOffline.text }
                        ]
                        show: details.modulesOnline.valid || details.modulesOffline.valid
                }

                MbItemRow {
                        description: qsTr("Nr. of modules blocking charge / discharge")
                        values: [
                                MbTextBlock { item.text: details.nrOfModulesBlockingCharge.text },
                                MbTextBlock { item.text: details.nrOfModulesBlockingDischarge.text }
                        ]
                        show: details.nrOfModulesBlockingCharge.valid || details.nrOfModulesBlockingDischarge.valid
                }

                MbItemRow {
                        description: qsTr("Installed / Available capacity")
                        values: [
                                MbTextBlock { item.text: details.installedCapacity.text },
                                MbTextBlock { item.bind: Utils.path(bindPrefix, "/Capacity") }
                        ]
                        show: details.installedCapacity.valid
                }

                MbItemRow {
                        description: qsTr("Connection information")
                        values: [
                                MbTextBlock { item.text: details.connectionInformation.text }
                        ]
                        show: details.connectionInformation.valid
                }

MbSubMenu {
    id: modules
    description: qsTr("Modules")
    subpage: Component {
        PageBatteryDetailsBatteryModules {
            title: modules.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}
}
}