import QtQuick 1.1 
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {


MbSubMenu {
    id: batteryCellVoltages12Item
    description: qsTr("Battery Cell Voltages")

    subpage: Component {
        PageBatteryDetailsCellVoltages12 {
            title: batteryCellVoltages12Item.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}


MbSubMenu {
    id: batteryCellTemperatures12Item
    description: qsTr("Battery Cell Temperatures")
    subpage: Component {
        PageBatteryDetailsCellTemperatures12 {
            title: batteryCellTemperatures12Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsTemperature12Item
    description: qsTr("BMS Temperature")
    subpage: Component {
        PageBatteryDetailsBMSTemperature12 {
            title: bmsTemperature12Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsCurrent12Item
    description: qsTr("Module Current")
    subpage: Component {
        PageBatteryDetailsBMSCurrent12 {
            title: bmsCurrent12Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}


        }
}
