import QtQuick 1.1 
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {


MbSubMenu {
    id: batteryCellVoltages13Item
    description: qsTr("Battery Cell Voltages")

    subpage: Component {
        PageBatteryDetailsCellVoltages13 {
            title: batteryCellVoltages13Item.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}


MbSubMenu {
    id: batteryCellTemperatures13Item
    description: qsTr("Battery Cell Temperatures")
    subpage: Component {
        PageBatteryDetailsCellTemperatures13 {
            title: batteryCellTemperatures13Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsTemperature13Item
    description: qsTr("BMS Temperature")
    subpage: Component {
        PageBatteryDetailsBMSTemperature13 {
            title: bmsTemperature13Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsCurrent13Item
    description: qsTr("Module Current")
    subpage: Component {
        PageBatteryDetailsBMSCurrent13 {
            title: bmsCurrent13Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}


        }
}
