import QtQuick 1.1 
import com.victron.velib 1.0
import "utils.js" as Utils

MbPage {
        id: root

        property string bindPrefix
        property BatteryDetails details: BatteryDetails { bindPrefix: root.bindPrefix }

        model: VisibleItemModel {


MbSubMenu {
    id: batteryCellVoltages6Item
    description: qsTr("Battery Cell Voltages")

    subpage: Component {
        PageBatteryDetailsCellVoltages6 {
            title: batteryCellVoltages6Item.description
            bindPrefix: root.bindPrefix
        }
    }

    show: true
}


MbSubMenu {
    id: batteryCellTemperatures6Item
    description: qsTr("Battery Cell Temperatures")
    subpage: Component {
        PageBatteryDetailsCellTemperatures6 {
            title: batteryCellTemperatures6Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsTemperature6Item
    description: qsTr("BMS Temperature")
    subpage: Component {
        PageBatteryDetailsBMSTemperature6 {
            title: bmsTemperature6Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}

MbSubMenu {
    id: bmsCurrent6Item
    description: qsTr("Module Current")
    subpage: Component {
        PageBatteryDetailsBMSCurrent6 {
            title: bmsCurrent6Item.description
            bindPrefix: root.bindPrefix
        }
    }
    show: true
}


        }
}
