#!/bin/sh

# Get the directory where this script lives (the mod folder)
MOD_DIR="$(cd "$(dirname "$0")" && pwd)"

echo "[INFO] Starting mod uninstallation..."

INITD_DIR="/etc/init.d"
DATA_DIR="/data"
QML_DIR="/opt/victronenergy/gui/qml"
BACKUP_DIR="$DATA_DIR/Venus_GUI_Mod/backup"

# 1. Remove init.d script
if [ -f "$INITD_DIR/batterycells" ]; then
    echo "[INFO] Removing init.d script..."
    update-rc.d -f batterycells remove  
    rm "$INITD_DIR/batterycells"        
fi


# 2. Remove installed scripts from /data
echo "[INFO] Removing installed scripts..."
rm -f "$DATA_DIR/batterycell_daemon.py"
rm -f "$DATA_DIR/parse_can.sh"

echo "[INFO] Removing velib_python directory..."
rm -rf "$DATA_DIR/velib_python"


# 3. Remove all added QML files and altered files before restoring backups
echo "[INFO] Removing added QML files..."

for i in $(seq 1 15); do
    rm -f "$QML_DIR/PageBatteryDetailsBatteryModule${i}.qml"
done

rm -f "$QML_DIR/PageBatteryDetailsBMSCurrent.qml"
for i in $(seq 2 15); do
    rm -f "$QML_DIR/PageBatteryDetailsBMSCurrent${i}.qml"
done

rm -f "$QML_DIR/PageBatteryDetailsBMSTemperatures.qml"
for i in $(seq 2 15); do
    rm -f "$QML_DIR/PageBatteryDetailsBMSTemperatures${i}.qml"
done

rm -f "$QML_DIR/PageBatteryDetailsCellVoltages.qml"
for i in $(seq 2 15); do
    rm -f "$QML_DIR/PageBatteryDetailsCellVoltages${i}.qml"
done

rm -f "$QML_DIR/PageBatteryCellTemperatures.qml"
for i in $(seq 2 15); do
    rm -f "$QML_DIR/PageBatteryCellTemperatures${i}.qml"
done

# Remove altered files
echo "[INFO] Removing altered QML files..."
rm -f "$QML_DIR/BatteryDetails.qml"
rm -f "$QML_DIR/PageBatteryDetails.qml"

# 4. Restore original QML files from backup
if [ -d "$BACKUP_DIR" ]; then
    for file in "BatteryDetails.qml" "PageBatteryDetails.qml"; do
        if [ -f "$BACKUP_DIR/${file}.copy" ]; then
            echo "[INFO] Restoring original $file..."
            cp "$BACKUP_DIR/${file}.copy" "$QML_DIR/$file"
        else
            echo "[WARNING] Backup for $file not found!"
        fi
    done
    # 5. Remove backup directory after restore
    echo "[INFO] Removing backup directory..."
    rm -rf "$BACKUP_DIR"
else
    echo "[WARNING] No backup directory found, originals cannot be restored!"
fi

# 6. Remove mod main folder if empty
if [ -d "$DATA_DIR/Venus_GUI_Mod" ]; then
    echo "[INFO] Removing mod folder..."
    rm -rf "$DATA_DIR/Venus_GUI_Mod"
fi

echo "[INFO] Uninstallation completed successfully. System restored to original state."
